﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.SceneManagement;
using UnityEngine.UI;
using UnityEngine.Video;

public class VideoPlayerScript : MonoBehaviour
{
    public RawImage VideoRawImage;  //Image used to display the frames of the video
    public VideoPlayer VideoPlayer; //The player of the video
    public AudioSource VideoAudio;  //The audio in the video
    public bool ShouldPlay; //A debug boolean used to skip the video


    private void Start()
    {
        if (ShouldPlay)
        {
            VideoPlayer.loopPointReached += VideoPlayer_loopPointReached;   //Event used to detect the end of the video
            StartCoroutine(PlayVideo());    //Let's play the video
        }

        else
        {
            //We're not playing the intro so jump straight to the menu
            gameObject.SetActive(false);
            SceneManager.LoadScene("Menu");
        }
    }

    private void VideoPlayer_loopPointReached(VideoPlayer source)
    {
        //The video's finished, load the menu
        gameObject.SetActive(false);
        SceneManager.LoadScene("Menu");
    }

    IEnumerator PlayVideo()
    {
        //Wait until the player has been prepared
        VideoPlayer.Prepare();
        
        WaitForSeconds waitForSeconds = new WaitForSeconds(1);
        while(!VideoPlayer.isPrepared)
        {
            yield return waitForSeconds;
        }

        //The player is ready, set the texture and begin playing the frames and audio
        VideoRawImage.texture = VideoPlayer.texture;
        VideoPlayer.Play();
        VideoAudio.Play();
    }
}
